#include <stdio.h>
#include <stdlib.h>
#include <algorithm>
#include <vector>
#include <numeric>
#include <math.h>
using namespace std;

struct Rope {
    long long t, c;
};

int main() {
    int n;
    if (scanf("%d", &n) != 1) return 0;

    vector<long long> x(n), h(n);
    for (int i = 0; i < n; i++) scanf("%lld", &x[i]);
    for (int i = 0; i < n; i++) scanf("%lld", &h[i]);

    vector<int> ord(n);
    iota(ord.begin(), ord.end(), 0);
    sort(ord.begin(), ord.end(), [&](int a, int b){ return x[a] < x[b]; });

    vector<int> pos(n);
    for (int i = 0; i < n; i++) pos[ord[i]] = i;

    vector<long long> xs(n), hs(n);
    for (int i = 0; i < n; i++) {
        xs[i] = x[ord[i]];
        hs[i] = h[ord[i]];
    }

    vector<int> prevGE(n, -1), nextGE(n, -1);
    {
        vector<int> st;
        for (int i = 0; i < n; i++) {
            while (!st.empty() && hs[st.back()] < hs[i]) st.pop_back();
            if (!st.empty()) prevGE[i] = st.back();
            st.push_back(i);
        }
    }
    {
        vector<int> st;
        for (int i = n - 1; i >= 0; i--) {
            while (!st.empty() && hs[st.back()] < hs[i]) st.pop_back();
            if (!st.empty()) nextGE[i] = st.back();
            st.push_back(i);
        }
    }

    vector<Rope> rope(n - 1);
    for (int i = 0; i + 1 < n; i++) {
        long long t = (hs[i] - hs[i+1] + xs[i] + xs[i+1]) / 2;
        long long c = hs[i] - llabs(xs[i] - t);
        rope[i] = {t, c};
    }

    auto bestDistOnInterval = [&](long long L, long long R, long long xi, long long t, long long c, long long H) -> long long {
        long long Rneed = H - c;
        if (Rneed <= 0) {
            if (R - L >= 1) {
                if (xi < R) return 1;
                if (xi > L) return 1;
            }
            return (long long)4e18;
        }
        long long leftEnd = min(R, t - Rneed);
        long long rightStart = max(L, t + Rneed);
        long long ans = (long long)4e18;
        if (leftEnd >= L) {
            long long d = xi - min(xi, leftEnd);
            if (d == 0) {
                if (leftEnd - L >= 1) d = 1;
                else d = (long long)4e18;
            }
            ans = min(ans, d);
        }
        if (rightStart <= R) {
            long long d = max(xi, rightStart) - xi;
            if (d == 0) {
                if (R - rightStart >= 1) d = 1;
                else d = (long long)4e18;
            }
            ans = min(ans, d);
        }
        return ans;
    };

    vector<long long> answer(n, -1);
    for (int i = 0; i < n; i++) {
        long long xi = xs[i], Hi = hs[i];
        long long best = (long long)4e18;
        if (prevGE[i] != -1) best = min(best, xi - xs[prevGE[i]]);
        if (nextGE[i] != -1) best = min(best, xs[nextGE[i]] - xi);
        if (i - 1 >= 0) {
            best = min(best, bestDistOnInterval(xs[i-1], xs[i], xi, rope[i-1].t, rope[i-1].c, Hi));
        }
        if (i + 1 < n) {
            best = min(best, bestDistOnInterval(xs[i], xs[i+1], xi, rope[i].t, rope[i].c, Hi));
        }
        if (best == (long long)4e18) answer[i] = -1;
        else answer[i] = best;
    }

    vector<long long> out(n);
    for (int i = 0; i < n; i++) out[ord[i]] = answer[i];
    for (int i = 0; i < n; i++) printf("%lld\n", out[i]);

    return 0;
}